--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An alchemy game object.
--- @class tes3alchemy : tes3item, tes3physicalObject, tes3object, tes3baseObject
--- @field autoCalc boolean If set, the value of the object is automatically calculated.
--- @field effects tes3effect[] *Read-only*. An array-style table of the [`tes3effect`](https://mwse.github.io/MWSE/types/tes3effect/) data on the object.
--- @field flags number The alchemy item's flags.
--- @field script tes3script The script that runs on the object.
--- @field value integer The value of the object. For this object type, its maximum value is 65535. Larger numbers will overflow.
--- @field weight number The weight of the object.
tes3alchemy = {}

--- Use [`tes3.createObject`](https://mwse.github.io/MWSE/apis/tes3/#tes3createobject) instead. Creates a new alchemy item, which will be stored as part of the current saved game. If there is already an alchemy item with matching effects, name, weight, value, and script, that will be returned instead of creating a new item.
--- @deprecated
--- @param params tes3alchemy.create.params This table accepts the following values:
--- 
--- `id`: string — The new object's ID. Must be unique.
--- 
--- `name?`: string — *Default*: `"Potion"`. The new item's name.
--- 
--- `script?`: tes3script|string — *Optional*. A script to attach to the object.
--- 
--- `mesh?`: string — *Default*: `"m\Misc_Potion_Bargain_01.nif"`. The mesh to use for the object.
--- 
--- `icon?`: string — *Default*: `"m\Tx_potion_bargain_01.nif"`. The icon to use for the object.
--- 
--- `objectFlags?`: number — *Default*: `8`. The object flags initially set. Force set as modified.
--- 
--- `weight?`: number — *Default*: `0`. The new item's weight.
--- 
--- `value?`: number — *Default*: `0`. The new item's value.
--- 
--- `flags?`: number — *Default*: `0`. The new alchemy item's flags.
--- 
--- `effects`: table — A table of effects described, providing values for id, skill, attribute, range, radius, duration, min, and/or max.
--- @return tes3alchemy newObject No description yet available.
function tes3alchemy.create(params) end

---Table parameter definitions for `tes3alchemy.create`.
--- @class tes3alchemy.create.params
--- @field id string The new object's ID. Must be unique.
--- @field name? string *Default*: `"Potion"`. The new item's name.
--- @field script? tes3script|string *Optional*. A script to attach to the object.
--- @field mesh? string *Default*: `"m\Misc_Potion_Bargain_01.nif"`. The mesh to use for the object.
--- @field icon? string *Default*: `"m\Tx_potion_bargain_01.nif"`. The icon to use for the object.
--- @field objectFlags? number *Default*: `8`. The object flags initially set. Force set as modified.
--- @field weight? number *Default*: `0`. The new item's weight.
--- @field value? number *Default*: `0`. The new item's value.
--- @field flags? number *Default*: `0`. The new alchemy item's flags.
--- @field effects table A table of effects described, providing values for id, skill, attribute, range, radius, duration, min, and/or max.

--- Creates a copy of this object.
--- @param params tes3alchemy.createCopy.params This table accepts the following values:
--- 
--- `id?`: string — *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- 
--- `addToObjectList?`: boolean — *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- 
--- `sourceless?`: boolean — *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.
--- @return tes3alchemy newObject No description yet available.
function tes3alchemy:createCopy(params) end

---Table parameter definitions for `tes3alchemy.createCopy`.
--- @class tes3alchemy.createCopy.params
--- @field id? string *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- @field addToObjectList? boolean *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- @field sourceless? boolean *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.

--- Returns the amount of effects the tes3alchemy object has.
--- @return number count No description yet available.
function tes3alchemy:getActiveEffectCount() end

--- Returns the index of a first effect of a given effectId in the parent tes3alchemy object.
--- @param effectId tes3.effect|integer The effectId to perform a check for. Maps to [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) constants.
--- @return integer index Returns 0-based index. Because Lua's arrays are 1-based, to index the potion's `effects` array with the return value add 1.
function tes3alchemy:getFirstIndexOfEffect(effectId) end

--- Determines if the alchemy item contains an effect with the given id.
--- @param effectId tes3.effect|integer A value from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return boolean hasEffect Returns `true` if the alchemy item contains the given effect id, otherwise `false`.
function tes3alchemy:hasEffect(effectId) end

